﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk2/detail/fnd/atk2_CriticalSection.h>

namespace nn { namespace atk2 { namespace detail { namespace fnd {

    CriticalSection::CriticalSection() NN_NOEXCEPT
    : m_Mutex(true)
    {
    }

    CriticalSection::~CriticalSection() NN_NOEXCEPT
    {
    }

    void CriticalSection::Lock() NN_NOEXCEPT
    {
        m_Mutex.Lock();
    }

    bool CriticalSection::TryLock() NN_NOEXCEPT
    {
        return m_Mutex.TryLock();
    }

    void CriticalSection::Unlock() NN_NOEXCEPT
    {
        m_Mutex.Unlock();
    }

}}}}
