﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#include <nn/atk2/detail/atk2_WaveBufferList.h>

#include <nn/atk2/atk2_AudioEngine.h>
#include <nn/atk2/detail/atk2_Filter.h>
#include <nn/atk2/detail/atk2_CommandManager.h>

namespace nn { namespace atk2 { namespace detail {

WaveBufferList::WaveBufferList() NN_NOEXCEPT
    : m_pWaveBufferListBegin(nullptr)
    , m_pWaveBufferListEnd(nullptr)
{
}

WaveBuffer* WaveBufferList::PeekFront() NN_NOEXCEPT
{
    return m_pWaveBufferListBegin;
}

WaveBuffer* WaveBufferList::PopFront() NN_NOEXCEPT
{
    WaveBuffer* currentWaveBuffer = m_pWaveBufferListBegin;
    m_pWaveBufferListBegin = currentWaveBuffer->next;

    if (m_pWaveBufferListBegin == nullptr)
    {
        m_pWaveBufferListEnd = nullptr;
    }

    return currentWaveBuffer;
}

bool WaveBufferList::PushBack(WaveBuffer* pWaveBuffer) NN_NOEXCEPT
{
    pWaveBuffer->next = nullptr;
    pWaveBuffer->state = WaveBufferState_Wait;

    if (m_pWaveBufferListBegin == nullptr)
    {
        m_pWaveBufferListBegin = pWaveBuffer;
    }
    else
    {
        m_pWaveBufferListEnd->next = pWaveBuffer;
    }

    m_pWaveBufferListEnd = pWaveBuffer;

    return true;
}

void WaveBufferList::Clear() NN_NOEXCEPT
{
    WaveBuffer* pWaveBuffer = m_pWaveBufferListBegin;
    while( pWaveBuffer != nullptr )
    {
        pWaveBuffer->state = WaveBufferState_Done;
        pWaveBuffer = pWaveBuffer->next;
    }
    m_pWaveBufferListBegin = nullptr;
    m_pWaveBufferListEnd = nullptr;
}

}}}
