﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk2/detail/atk2_VoiceReplyCommandManager.h>

#include <nn/util/util_BytePtr.h>

namespace nn { namespace atk2 { namespace detail {

    VoiceReplyCommandManager::VoiceReplyCommandManager() NN_NOEXCEPT
    {
    }

    void VoiceReplyCommandManager::GetDefaultInitArg(InitArg& arg, PlatformInitArg& platformArg) NN_NOEXCEPT
    {
        NN_UNUSED(platformArg);
        arg.waveBufferPacketCount = 512;
    }

    size_t VoiceReplyCommandManager::GetRequiredBufferSize(const InitArg& arg, const PlatformInitArg& platformArg) NN_NOEXCEPT
    {
        NN_UNUSED(platformArg);
        size_t result = 0;
        result += arg.commandBufferSize;
        return result;
    }

    void VoiceReplyCommandManager::Initialize(InitArg& arg, PlatformInitArg& platformArg) NN_NOEXCEPT
    {
        NN_UNUSED(platformArg);
        nn::util::BytePtr workBuffer( arg.workBuffer );

        m_CommandBuffer = workBuffer.Get();
        m_CommandBufferSize = arg.commandBufferSize;
        workBuffer.Advance( arg.commandBufferSize );

        CommandManager::Initialize(arg.workBuffer, arg.commandBufferSize);
        m_pAudioEngine = arg._pAudioEngine;
    }

    void VoiceReplyCommandManager::ProcessCommandList( Command* commandList ) NN_NOEXCEPT
    {
        Command* command = commandList;

        while( command != NULL )
        {
            switch( command->id )
            {
            case VoiceReplyCommandId_WaveBufferUpdate:
            {
                break;
            }
            default:
                break;
            } // switch

            command = command->next;
        } // while
    }

}}}
