﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/detail/atk_SoundEditConnection.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

#include <nn/atk/viewer/detail/protocol/atk_QueryItemInfoPacket.h>

namespace nn {
namespace atk {
namespace viewer {
namespace detail {

//----------------------------------------------------------
SoundEditConnection::SoundEditConnection() NN_NOEXCEPT :
m_SoundArchiveEditor(NULL),
m_HioManager(NULL),
m_SyncChannel(NULL),
m_FuncChannel(NULL),
m_CacheSyncInterval(0),
m_SendTimeout(0),
m_SendPacketBufferSize(0)
{
}

//----------------------------------------------------------
Result
SoundEditConnection::Initialize(const InitializeArgs& args) NN_NOEXCEPT
{
    if(IsInitialized())
    {
        NN_SDK_ASSERT(false, "SoundEditConnection is already initialized.\n");
        return Result(ResultType_Failed);
    }

    if(args.buffer == NULL ||
        args.cacheSyncInterval == 0 ||
        args.sendTimeout == 0 ||
        args.maxItemName == 0 ||
        args.hioManager == NULL ||
        args.syncChannel == NULL ||
        args.funcChannel == NULL)
    {
        NN_SDK_ASSERT(false, "invalid arguments.\n");
        return Result(ResultType_Failed);
    }

    size_t queryItemInfoPacketBufferSize =
        detail::QueryItemInfoPacket::GetRequiredSize(args.maxItemName);

    if(args.bufferLength < queryItemInfoPacketBufferSize)
    {
        return Result(ResultType_OutOfMemory);
    }

    m_SendPacketBuffer = reinterpret_cast<QueryItemInfoPacket*>(args.buffer);
    m_SendPacketBufferSize = queryItemInfoPacketBufferSize;

    m_HioManager = args.hioManager;
    m_SyncChannel = args.syncChannel;
    m_FuncChannel = args.funcChannel;
    m_CacheSyncInterval = args.cacheSyncInterval;
    m_SendTimeout = args.sendTimeout;

    SetupSyncChannel(args.maxItemName);

    return Result(ResultType_True);
}

//----------------------------------------------------------
atk::detail::fnd::FileStream*
SoundEditConnection::OpenFile(void* buffer, size_t bufferLength, const char* filePath) NN_NOEXCEPT
{
    if(!IsInitialized())
    {
        NN_SDK_ASSERT(false, "SoundEditConnection is not initialized.\n");
        return NULL;
    }

    if(!IsOpened())
    {
        return NULL;
    }

    atk::detail::fnd::FileStream* result = m_HioManager->OpenFile(buffer, bufferLength, filePath);

    if(result == NULL)
    {
        NN_DETAIL_ATK_INFO("[sndedit] failed to open file : filepath=%s.\n", filePath);
    }

    return result;
}

} // namespace nn::atk::viewer::detail
} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
