﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/detail/atk_SoundControllerImpl.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

#include <nn/atk/atk_SoundHandle.h>
#include <nn/atk/atk_StreamSoundHandle.h>
#include <nn/atk/atk_SequenceSoundHandle.h>
#include <nn/atk/atk_SoundArchive.h>
#include <nn/atk/atk_SoundArchivePlayer.h>

namespace nn {
namespace atk {
namespace viewer {
namespace detail {

//----------------------------------------------------------
void
SoundControllerImpl::UpdateParameters() NN_NOEXCEPT
{
    if(!m_IsParameterDirty)
    {
        return;
    }

    if(!m_SoundHandle->IsAttachedSound())
    {
        return;
    }

    // 全体設定
    m_SoundHandle->SetVolume(m_Parameters.volume);
    m_SoundHandle->SetPan(m_Parameters.pan);
    m_SoundHandle->SetSurroundPan(m_Parameters.surroundPan);
    m_SoundHandle->SetMainSend(m_Parameters.mainSend);
    m_SoundHandle->SetEffectSend(AuxBus_A, m_Parameters.effectSend[0]);
    m_SoundHandle->SetEffectSend(AuxBus_B, m_Parameters.effectSend[1]);
    m_SoundHandle->SetEffectSend(AuxBus_C, m_Parameters.effectSend[2]);

    // MAIN設定
    m_SoundHandle->SetOutputVolume(OutputDevice_Main, m_Parameters.mainOutVolume);
    m_SoundHandle->SetOutputPan(OutputDevice_Main, m_Parameters.mainPan);
    m_SoundHandle->SetOutputSurroundPan(OutputDevice_Main, m_Parameters.mainSurroundPan);
    m_SoundHandle->SetOutputMainSend(OutputDevice_Main, m_Parameters.mainMainSend);
    m_SoundHandle->SetOutputEffectSend(OutputDevice_Main, AuxBus_A, m_Parameters.mainEffectSend[0]);
    m_SoundHandle->SetOutputEffectSend(OutputDevice_Main, AuxBus_B, m_Parameters.mainEffectSend[1]);
    m_SoundHandle->SetOutputEffectSend(OutputDevice_Main, AuxBus_C, m_Parameters.mainEffectSend[2]);

    // 共通設定
    m_SoundHandle->SetPitch(m_Parameters.pitch);
    m_SoundHandle->SetLowPassFilterFrequency(m_Parameters.lowPassFilterFrequency);
    m_SoundHandle->SetBiquadFilter(m_Parameters.biquadFilterType, m_Parameters.biquadFilterValue);

    uint32_t outputLine = 0;

    if(m_Parameters.isMainOutEnabled)
    {
        outputLine |= OutputLine_Main;
    }

    m_SoundHandle->SetOutputLine(outputLine);

    SoundArchive::SoundType soundType = m_SoundArchivePlayer->GetSoundArchive().GetSoundType(m_SoundId);

    switch(soundType)
    {
    case nn::atk::SoundArchive::SoundType_Stream:
        {
            StreamSoundHandle streamSoundHandle(m_SoundHandle);
            uint32_t trackFlag = 0x1;

            for (uint32_t index = 0; index < viewer::Limits::StreamTrackCountMax; ++index)
            {
                if (m_Parameters.tracksMute[index])
                {
                    streamSoundHandle.SetTrackVolume(trackFlag, 0.0f);
                }
                else
                {
                    streamSoundHandle.SetTrackVolume(trackFlag, m_Parameters.tracksVolume[index]);
                }

                trackFlag <<= 1;
            }
        }
        break;

    case nn::atk::SoundArchive::SoundType_Sequence:
        {
            SequenceSoundHandle sequenceSoundHandle(m_SoundHandle);
            uint32_t trackFlag = 0x1;

            for (uint32_t index = 0; index < viewer::Limits::SequenceTrackCountMax; ++index)
            {
                sequenceSoundHandle.SetTrackMute(trackFlag, m_Parameters.tracksMute[index]);
                sequenceSoundHandle.SetTrackVolume(trackFlag, m_Parameters.tracksVolume[index]);
                trackFlag <<= 1;
            }
        }
        break;

    default:
        break;
    }

    ApplySequenceVariables();

    m_IsParameterDirty = false;
}

} // namespace nn::atk::viewer::detail
} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
