﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/detail/handler/atk_PauseSoundHandler.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

#include <nn/atk/viewer/atk_SoundObjectController.h>

namespace nn {
namespace atk {
namespace viewer {
namespace detail {

//----------------------------------------------------------
void
PauseSoundHandler::SetSoundObjectController(SoundObjectController* soundObjectController) NN_NOEXCEPT
{
    m_SoundObjectController = soundObjectController;
}

//----------------------------------------------------------
viewer::detail::HioResult
PauseSoundHandler::OnInvokeForReadTargetPacket(
    const PauseSoundPacket& packet,
    viewer::detail::HioPacketStream& /*stream*/) NN_NOEXCEPT
{
    if(m_SoundObjectController == NULL)
    {
        return viewer::detail::HioResult(viewer::detail::HioResultType_False);
    }

    SoundController* controller = m_SoundObjectController->GetSoundController(
        packet.GetBody().GetSoundHandleIndex()
        );

    if(controller == NULL)
    {
        return viewer::detail::HioResult(viewer::detail::HioResultType_True);
    }

    controller->Pause();

    return viewer::detail::HioResult(viewer::detail::HioResultType_True);
}

} // namespace nn::atk::viewer::detail
} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
