﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/atk/fnd/string/atkfnd_String.h>
#include <nn/atk/fnd/string/atkfnd_Path.h>
#if defined(NN_BUILD_CONFIG_OS_WIN)
#include <windows.h>
#endif

// TODO: nn_fs? 環境変数展開が必要（現状は、atkfnd_HioStreamWin.cpp と同一の内容）

namespace nn {
namespace atk {
namespace detail {
namespace fnd {

//----------------------------------------------------------
void
Path::ConvertToPcFilePath(
    const char* src,
    uint32_t srcLength,
    char* dest,
    uint32_t destLength,
    const char* /* volume */,
    uint32_t /* volumeLength */) NN_NOEXCEPT
{
    String::Copy(
        dest,
        destLength,
        src,
        srcLength);
}

//----------------------------------------------------------
uint32_t
Path::ExpandEnvironmentVariables(
    char* dest,
    uint32_t destLength,
    const char* src,
    uint32_t /* srcLength */) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_WIN)
    return ExpandEnvironmentStringsA(src, dest, destLength);
#else
    NN_UNUSED(dest);
    NN_UNUSED(destLength);
    NN_UNUSED(src);
    return 0;
#endif
}

const char* TrimDirPath(const char* path, char delim) NN_NOEXCEPT
{
    const char* trimmedPath = std::strrchr(path, delim);
    return trimmedPath != nullptr ? trimmedPath + 1 : path;
}

} // namespace nn::atk::detail::fnd
} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn
