﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_EffectBase.h>

namespace nn {
namespace atk {

NN_DEFINE_STATIC_CONSTANT(const int EffectBase::ChannelModeCountMax);

EffectBase::EffectBase() NN_NOEXCEPT
    : m_IsActive (false)
    , m_SampleRate(SampleRate_48000)
{
}

EffectBase::~EffectBase() NN_NOEXCEPT
{
}

bool EffectBase::AddEffect(nn::audio::AudioRendererConfig* pConfig, nn::atk::OutputMixer* pOutputMixer) NN_NOEXCEPT
{
    NN_UNUSED(pConfig);
    NN_UNUSED(pOutputMixer);
    return true;
}

void EffectBase::SetEffectInputOutput(const int8_t* input, const int8_t* output, int inputCount, int outputCount) NN_NOEXCEPT
{
    NN_UNUSED(input);
    NN_UNUSED(output);
    NN_UNUSED(inputCount);
    NN_UNUSED(outputCount);
}

void EffectBase::RemoveEffect(nn::audio::AudioRendererConfig* pConfig, nn::atk::OutputMixer* pOutputMixer) NN_NOEXCEPT
{
    NN_UNUSED(pConfig);
    NN_UNUSED(pOutputMixer);
}

void EffectBase::OnChangeOutputMode() NN_NOEXCEPT
{
}

void EffectBase::SetEffectBuffer(void* effectBuffer, size_t effectBufferSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(effectBuffer);
    NN_SDK_ASSERT_GREATER_EQUAL(effectBufferSize, this->GetRequiredMemSize());

    m_EffectBuffer = effectBuffer;
    m_EffectBufferSize = effectBufferSize;
}

int EffectBase::ConvertChannelModeToInt(ChannelMode mode) NN_NOEXCEPT
{
    switch (mode)
    {
    case nn::atk::EffectBase::ChannelMode_1Ch:
        return 1;
    case nn::atk::EffectBase::ChannelMode_2Ch:
        return 2;
    case nn::atk::EffectBase::ChannelMode_4Ch:
        return 4;
    case nn::atk::EffectBase::ChannelMode_6Ch:
        return 6;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

void EffectBase::UpdateBuffer(
    int numChannels,
    void* buffer[],
    size_t bufferSize,
    SampleFormat format,
    int sampleRate,
    OutputMode mode
) NN_NOEXCEPT
{
    NN_UNUSED(mode);
    NN_UNUSED(sampleRate);
    NN_UNUSED(format);
    NN_UNUSED(bufferSize);
    NN_UNUSED(buffer);
    NN_UNUSED(numChannels);
}

EffectBase::SampleRate EffectBase::GetSampleRate() const NN_NOEXCEPT
{
    return m_SampleRate;
}

bool EffectBase::SetSampleRate(SampleRate rate) NN_NOEXCEPT
{
    if( m_IsActive )
    {
        return false;
    }
    else
    {
        m_SampleRate = rate;
        return true;
    }
}

void EffectBase::GetChannelIndex(ChannelIndex* pChannel, int channelCount) const NN_NOEXCEPT
{
    NN_UNUSED(pChannel);
    NN_UNUSED(channelCount);
}

int EffectBase::GetChannelSettingCountMax() const NN_NOEXCEPT
{
    return 0;
}

#if 0 // 参考用 : NW4F 実装
AXFX_SAMPLE_RATE EffectBase::GetEffectSampleRate( SampleRate rate )
{
    AXFX_SAMPLE_RATE fxRate = AXFX_SAMPLE_RATE_32000;

    if ( rate == SampleRate_32000 )
    {
        fxRate = AXFX_SAMPLE_RATE_32000;
    }
#if defined(NN_ATK_CONFIG_ENABLE_SOUND2)
    else if ( rate == SAMPLE_RATE_48000 )
    {
        fxRate = AXFX_SAMPLE_RATE_48000;
    }
#endif

    return fxRate;
}
#endif

} // namespace nn::atk
} // namespace nn
