﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/detail/atk_MemoryFileStream.h>

#include <nn/util/util_BytePtr.h>

namespace nn { namespace atk { namespace detail {

    MemoryFileStream::MemoryFileStream( const void* buffer, size_t size ) NN_NOEXCEPT
    : m_pBuffer( buffer )
    , m_Size( size )
    , m_Position( 0 )
    {
    }

    void MemoryFileStream::Close() NN_NOEXCEPT
    {
        m_pBuffer = NULL;
        m_Size = 0;
        m_Position = 0;
    }

    size_t MemoryFileStream::Read( void* buf, size_t length, fnd::FndResult* result/* = nullptr*/ ) NN_NOEXCEPT
    {
        NN_UNUSED(result);
        size_t readLen = std::min( length, m_Size - m_Position );
        std::memcpy( buf, util::ConstBytePtr( m_pBuffer, m_Position ).Get(), readLen );
        m_Position += readLen;
        return readLen;
    }

    fnd::FndResult MemoryFileStream::Seek( position_t offset, fnd::Stream::SeekOrigin origin ) NN_NOEXCEPT
    {
        switch( origin ) {
        case fnd::Stream::SeekOrigin::SeekOrigin_Begin:
            m_Position = offset;
            break;

        case fnd::Stream::SeekOrigin::SeekOrigin_Current:
            m_Position += offset;
            break;

        case fnd::Stream::SeekOrigin::SeekOrigin_End:
            m_Position = m_Size - offset;
            break;

        default:
            NN_SDK_ASSERT( false, "Unsupported Seek origin" );
            return fnd::FndResult(fnd::FndResultType_Failed);
        }

        return fnd::FndResult(fnd::FndResultType_True);
    }

}}}
