﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_GroupFile.h>
#include <nn/atk/atk_ElementType.h>

namespace nn {
namespace atk {
namespace detail {

NN_DEFINE_STATIC_CONSTANT( const uint32_t GroupFile::GroupItemInfo::OffsetForLink );
NN_DEFINE_STATIC_CONSTANT( const uint32_t GroupFile::GroupItemInfo::SizeForLink );

//
// GroupFile::FileHeader
//
const GroupFile::InfoBlock* GroupFile::FileHeader::GetInfoBlock() const NN_NOEXCEPT
{
    return static_cast<const InfoBlock*>( GetBlock( ElementType_GroupFile_InfoBlock ) );
}
const GroupFile::FileBlock* GroupFile::FileHeader::GetFileBlock() const NN_NOEXCEPT
{
    return static_cast<const FileBlock*>( GetBlock( ElementType_GroupFile_FileBlock ) );
}
const GroupFile::InfoExBlock* GroupFile::FileHeader::GetInfoExBlock() const NN_NOEXCEPT
{
    return static_cast<const InfoExBlock*>( GetBlock( ElementType_GroupFile_InfoExBlock ) );
}

} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn

