﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/atk/detail/atk_AdvancedWaveSound.h>

#include <nn/atk/atk_SoundInstanceManager.h>
#include <nn/atk/atk_DriverCommand.h>

namespace nn { namespace atk { namespace detail {

    AdvancedWaveSound::AdvancedWaveSound( AdvancedWaveSoundInstanceManager& manager ) NN_NOEXCEPT
    : m_InstanceManager( manager )
    , m_IsInitialized(false)
    {
    }

    AdvancedWaveSound::~AdvancedWaveSound() NN_NOEXCEPT
    {

    }

    bool AdvancedWaveSound::Initialize(OutputReceiver* pOutputReceiver) NN_NOEXCEPT
    {
        bool result = BasicSound::Initialize( pOutputReceiver );
        if( !result )
        {
            return false;
        }

        m_pTempSpecialHandle = nullptr;

        m_IsInitialized = true;
        return true;
    }

    void AdvancedWaveSound::Finalize() NN_NOEXCEPT
    {
        if ( ! m_IsInitialized )
        {
            return;
        }
        m_IsInitialized = false;

        m_pTempSpecialHandle = nullptr;

        BasicSound::Finalize();
        m_InstanceManager.Free( this );
    }

    void AdvancedWaveSound::Prepare( const driver::AdvancedWaveSoundPlayer::PrepareParameter& parameter ) NN_NOEXCEPT
    {
        NN_SDK_ASSERT( m_IsInitialized );
        NN_SDK_ASSERT_NOT_NULL( parameter.pAwsdFile );
        NN_SDK_ASSERT_NOT_NULL( parameter.pWarcFile );

        // コマンド
        {
            DriverCommand& cmdmgr = DriverCommand::GetInstance();
            DriverCommandAdvancedWaveSoundPrepare* command =
                cmdmgr.AllocCommand<DriverCommandAdvancedWaveSoundPrepare>();
            command->id = DriverCommandId_AwsdPrepare;
            command->player = &m_PlayerInstance;
            command->parameter = parameter; // 構造体コピー
            cmdmgr.PushCommand(command);
        }
    }

    void AdvancedWaveSound::OnUpdatePlayerPriority() NN_NOEXCEPT
    {
        int priority = CalcCurrentPlayerPriority();
        m_InstanceManager.UpdatePriority( this, priority );
    }

    bool AdvancedWaveSound::IsAttachedTempSpecialHandle() NN_NOEXCEPT
    {
        return m_pTempSpecialHandle != NULL;
    }

    void AdvancedWaveSound::DetachTempSpecialHandle() NN_NOEXCEPT
    {
        // TODO: m_pTempSpecialHandle->DetachSound();
    }

}}} // namespace nn::atk::detail
