﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_SequenceSoundHandle.h>

#include <nn/atk/atk_SoundHandle.h>

namespace nn {
namespace atk {

NN_DEFINE_STATIC_CONSTANT( const int SequenceSoundHandle::BankIndexMin );
NN_DEFINE_STATIC_CONSTANT( const int SequenceSoundHandle::BankIndexMax );
NN_DEFINE_STATIC_CONSTANT( const int8_t SequenceSoundHandle::TransposeMin );
NN_DEFINE_STATIC_CONSTANT( const int8_t SequenceSoundHandle::TransposeMax );
NN_DEFINE_STATIC_CONSTANT( const uint8_t SequenceSoundHandle::VelocityRangeMin );
NN_DEFINE_STATIC_CONSTANT( const uint8_t SequenceSoundHandle::VelocityRangeMax );
NN_DEFINE_STATIC_CONSTANT( const int SequenceSoundHandle::VariableIndexMax );
NN_DEFINE_STATIC_CONSTANT( const int SequenceSoundHandle::TrackIndexMax );

/*--------------------------------------------------------------------------------*
  Name:         SequenceSoundHandle

  Description:  変換コンストラクタ

  Arguments:    sound - 関連付けるサウンド

  Returns:      None.
 *--------------------------------------------------------------------------------*/
SequenceSoundHandle::SequenceSoundHandle( SoundHandle* handle ) NN_NOEXCEPT
: m_pSound( NULL )
{
    if ( handle == NULL ) return;

    // 汎用ハンドルからサウンドを取得
    if ( !handle->IsAttachedSound() ) return;

    detail::SequenceSound* sound =
        detail::fnd::DynamicCast<detail::SequenceSound*>( handle->detail_GetAttachedSound() );

    if ( sound != NULL )
    {
        // シーケンスサウンドなら一時ハンドルとしてAttachする
        detail_AttachSoundAsTempHandle( sound );
    }
}

/*--------------------------------------------------------------------------------*
  Name:         detail_AttachSoundAsTempHandle

  Description:  ハンドルにサウンドを関連付ける

  Arguments:    sound - 関連付けるサウンド

  Returns:      None.
 *--------------------------------------------------------------------------------*/
void SequenceSoundHandle::detail_AttachSoundAsTempHandle( detail::SequenceSound* sound ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( sound );

    m_pSound = sound;

    // 一時ハンドルとしてAttachする
    if ( m_pSound->IsAttachedTempSpecialHandle() )
    {
        m_pSound->DetachTempSpecialHandle();
    }
    m_pSound->m_pTempSpecialHandle = this;
}

/*--------------------------------------------------------------------------------*
  Name:         DetachSound

  Description:  ハンドルに結びついているサウンドの関連を外す

  Arguments:    None.

  Returns:      None.
 *--------------------------------------------------------------------------------*/
void SequenceSoundHandle::DetachSound() NN_NOEXCEPT
{
    if ( IsAttachedSound() )
    {
        if ( m_pSound->m_pTempSpecialHandle == this ) m_pSound->m_pTempSpecialHandle = NULL;
    }
    if ( m_pSound != NULL ) m_pSound = NULL;
}

} // namespace nn::atk
} // namespace nn

