﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_AdvancedWaveSoundHandle.h>
#include <nn/atk/atk_SoundHandle.h>

namespace nn { namespace atk {

AdvancedWaveSoundHandle::AdvancedWaveSoundHandle( SoundHandle* handle ) NN_NOEXCEPT
: m_pSound( NULL )
{
    if ( handle == NULL )
    {
        return;
    }

    // 汎用ハンドルからサウンドを取得
    if ( !handle->IsAttachedSound() )
    {
        return;
    }

    /*
    detail::AdvancedWaveSound* sound =
        nw::ut::DynamicCast<detail::WaveSound*>( handle->detail_GetAttachedSound() );

    if ( sound != NULL )
    {
        // シーケンスサウンドなら一時ハンドルとしてAttachする
        detail_AttachSoundAsTempHandle( sound );
    }
    */
}

void AdvancedWaveSoundHandle::DetachSound() NN_NOEXCEPT
{
    if ( IsAttachedSound() )
    {
        if ( m_pSound->m_pTempSpecialHandle == this )
        {
            m_pSound->m_pTempSpecialHandle = NULL;
        }
    }

    if ( m_pSound != NULL )
    {
        m_pSound = NULL;
    }
}

void AdvancedWaveSoundHandle::detail_AttachSoundAsTempHandle( detail::AdvancedWaveSound* sound ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( sound );

    m_pSound = sound;

    // 一時ハンドルとしてAttachする
    if ( m_pSound->IsAttachedTempSpecialHandle() )
    {
        m_pSound->DetachTempSpecialHandle();
    }
    m_pSound->m_pTempSpecialHandle = this;
}

}} // namespace nn::atk
