﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace atk2 { namespace detail {

    // @brief ADPCM パラメータです
    struct AdpcmParam
    {
        uint16_t coef[8][2]; //!< Adpcm の係数
    };

    // @brief ADPCM コンテキストです
    struct AdpcmContext
    {
        uint16_t pred_scale; //!< Adpcm の予測値（4bit）、スケール値（4bit）を格納します。上位8 ビットは参照されません。
        int16_t yn1;         //!< 履歴データ（1 つ前のサンプル値）
        int16_t yn2;         //!< 履歴データ（2 つ前のサンプル値）
    };

    // TODO: プレイヤー層で使用する際にコメントイン
#if 0
    struct DspAdpcmParam
    {
        uint16_t coef[8][2];
        uint16_t predScale;
        uint16_t yn1;
        uint16_t yn2;
    };

    struct DspAdpcmLoopParam
    {
        uint16_t loopPredScale;
        uint16_t loopYn1;
        uint16_t loopYn2;
    };
#endif
}}}
