﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace atk2 {

//! @internal
class OutputReceiver
{
public:
    //! @internal
    enum class ReceiverType
    {
        ReceiverType_SubMix,
        ReceiverType_FinalMix
    };

    //! @internal
    virtual ReceiverType GetReceiverType() const NN_NOEXCEPT = 0;
    //! @internal
    virtual int GetChannelCount() const NN_NOEXCEPT = 0;
    //! @internal
    virtual int GetBusCount() const NN_NOEXCEPT = 0;
    //! @internal
    inline int GetMixBufferCount() const NN_NOEXCEPT
    {
        return GetBusCount() * GetChannelCount();
    }
    //! @internal
    virtual void AddReferenceCount(int value) NN_NOEXCEPT = 0;
};

}}
