﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace atk2 {

    // @brief オーディオフレーム間隔で更新処理を行うものを表すインタフェースです
    class IAudioFrameUpdate
    {
    public:
        virtual ~IAudioFrameUpdate() NN_NOEXCEPT {}
    public:
        // @brief 更新処理を行います
        virtual bool Update() NN_NOEXCEPT = 0;
    public:
        util::IntrusiveListNode m_Link;
    };
}}
