﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/audio/audio_FinalMixTypes.h>
#include <nn/atk2/atk2_OutputMixer.h>

namespace nn {

    namespace audio {
        struct AudioRendererConfig;
    }

namespace atk2 {

//! @internal
class FinalMix : public OutputMixer
{
public:
    //!@internal
    bool Initialize(nn::audio::AudioRendererConfig* pConfig, int channelCount) NN_NOEXCEPT;
    //! @internal
    void Finalize(nn::audio::AudioRendererConfig* pConfig) NN_NOEXCEPT;

    //! @internal
    //void SetupEffect(EffectBase* pEffect, int bus) NN_NOEXCEPT NN_OVERRIDE;
    //! @internal
    //void SetupEffect(EffectAux* pEffect, int bus) NN_NOEXCEPT NN_OVERRIDE;

    //! @internal
    virtual ReceiverType GetReceiverType() const NN_NOEXCEPT NN_OVERRIDE;
    //! @internal
    virtual int GetChannelCount() const NN_NOEXCEPT NN_OVERRIDE;
    //! @internal
    virtual int GetBusCount() const NN_NOEXCEPT NN_OVERRIDE;
    //! @internal
    inline nn::audio::FinalMixType* GetAudioFinalMixInstance() NN_NOEXCEPT
    {
        return &m_FinalMix;
    }
    //! @internal
    virtual void AddReferenceCount(int value) NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::audio::FinalMixType m_FinalMix;
    std::atomic<uint32_t> m_ReferenceCount;
    int m_ChannelCount;
};

}}
