﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Drawing.Imaging;

namespace QCIT_Maker
{
    internal class PictureCreator
    {
        public static void CreateBitmapIconFile(string inSaveFilePath, SettingParams inSetParam)
        {
            // アイコン画像の仕様に合わせて BMP 24bit の 1024 x 1024 の画像を出力する
            int canvasWidth = 1024;
            int canvasHeight = 1024;
            using (var canvas = new Bitmap(canvasWidth, canvasHeight, PixelFormat.Format24bppRgb))
            {
                using (var g = Graphics.FromImage(canvas))
                {
                    // 描画するフォントの設定
                    string fontName = "Arial";
                    float fontSize = 65.0f;
                    var fontStyle = FontStyle.Bold;
                    var strColor = Brushes.LightYellow;

                    // 表示文字列はアイコン全体に対して中央寄せにする
                    var strFormat = new StringFormat();
                    strFormat.Alignment = StringAlignment.Center;
                    strFormat.LineAlignment = StringAlignment.Near;

                    // 背景色の設定
                    g.FillRectangle(Brushes.DodgerBlue, g.VisibleClipBounds);

                    float posY = 130.0f;
                    float gap = 250.0f;

                    using (var titleFont = new Font(fontName, fontSize * 2.5f, fontStyle))
                    {
                        var langRect = new RectangleF(0.0f, posY, canvasWidth, 300.0f);
                        // QCIT 文字列を描く
                        g.DrawString("QCIT", titleFont, strColor, langRect, strFormat);
                    }

                    posY += (gap + 150.0f);
                    using (var idFont = new Font(fontName, fontSize * 1.05f, fontStyle))
                    {
                        var idRect = new RectangleF(0.0f, posY, canvasWidth, 200.0f);
                        // アプリID を描く
                        g.DrawString(inSetParam.ApplicationId, idFont, strColor, idRect, strFormat);
                    }

                    posY += gap;
                    using (var verFont = new Font(fontName, fontSize * 1.5f, fontStyle))
                    {
                        var rvRect = new RectangleF(0.0f, posY, canvasWidth, 300.0f);
                        string rvStr = string.Format("ver. {0}", inSetParam.ReleaseVersion);
                        // ReleaseVersion の値を描く
                        g.DrawString(rvStr, verFont, strColor, rvRect, strFormat);
                    }
                }

                // 指定したパスにファイルとして保存
                canvas.Save(inSaveFilePath);
            }
        }
    }
}
