﻿using System;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using CommandUtility;

namespace BackupRestoreGui
{
    class Program
    {
        static void Cleanup()
        {
            // 一つ目の起動時にクリーンアップを行う
            if (System.Diagnostics.Process.GetProcessesByName(
                System.Diagnostics.Process.GetCurrentProcess().ProcessName).Length == 1)
            {
                EnsureExistingLogDirectoryPath();
                var lockFiles = Directory.EnumerateFiles(
                    Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate", "Outputs"), "*.lock");

                foreach(var i in lockFiles)
                {
                    File.Delete(i);
                }

                var processes = System.Diagnostics.Process.GetProcesses();
                var killTarget = processes.Where(i =>
                i.ProcessName.Contains("RunOnTargetPrivate") ||
                i.ProcessName.Contains("RecoveryBoot") ||
                i.ProcessName.Contains("UpdateHostBridge") ||
                i.ProcessName.Contains("RunOnTarget") ||
                i.ProcessName.Contains("ControlTarget") ||
                i.ProcessName.Contains("RunOnTargetFromNand") ||
                i.ProcessName.Contains("RunSystemInitializerManu") ||
                i.ProcessName.Contains("RequestToWsIssuer")
                );

                foreach (var i in killTarget)
                {
                    ProcessUtility.KillProcess(i);
                }
            }
        }

        public static void EnsureExistingLogDirectoryPath()
        {
            System.IO.Directory.CreateDirectory(GetLogDirecotryPath());
        }

        public static string GetLogDirecotryPath()
        {
            return Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate", "Outputs", "BackupRepairToolLog");
        }


        [STAThread]
        static void Main(string[] args)
        {
            Cleanup();
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            if(args.Contains("backup"))
            {
                Application.Run(new MainForm(ToolMode.Backup, args.Contains("develop"), args.Contains("forcibly"), args.Contains("signed")));
            }
            else if(args.Contains("restore"))
            {
                Application.Run(new MainForm(ToolMode.Restore, args.Contains("develop"), false, args.Contains("signed")));
            }
            else
            {
                Application.Run(new MainForm(ToolMode.Backup, args.Contains("develop"), args.Contains("forcibly"), args.Contains("signed")));
            }
        }
    }
}

