﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO.Ports;

namespace ReadProductInfo
{
    class Program
    {
        private static void ConsoleWriteBytesData(byte[] data)
        {
            int index = 0;
            int size = data.Length;
            while (size > 0)
            {
                //if (index != 0)
                //{
                //    Console.Write(" ");
                //}
                Console.Write("{0:X2}", data[index]);
                index++;
                size--;
            }
        }

        static void Main(string[] args)
        {
            if (args.Length < 1)
            {
                Console.WriteLine("Usage: ReadProductInfo <com_port>");
                Environment.Exit(1);
            }

            string comPort = args[0];

            // HCI-UART 通信
            byte[] commandReadRAM =
            {
                0x01,
                0x4D, 0xFC,
                0x05,
                0x10, 0x60, 0x00, 0xFF,
                0x10
            };
            byte[] expectedResultReadRAM =
            {
                0x04,
                0x0E,
                0x14,
                0x01, 0x4D, 0xFC, 0x00,
                0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
            };

            // UART 通信確立
            SerialPort serialPort = new SerialPort();

            // SerialPort.Open
            serialPort.PortName = comPort;
            serialPort.BaudRate = 115200;
            serialPort.DataBits = 8;
            serialPort.Parity = Parity.None;
            serialPort.StopBits = StopBits.One;
            serialPort.Handshake = Handshake.RequestToSend;
            serialPort.Encoding = Encoding.UTF8;

            serialPort.Open();

            // バッファクリア
            serialPort.DiscardInBuffer();
            serialPort.DiscardOutBuffer();

            byte[] result;
            byte[] productInfo;
            int bytesInBuffer;
            int retry;

            //Console.WriteLine("cts: {0:X2}", serialPort.CtsHolding);
            if (!serialPort.CtsHolding)
            {
                Console.WriteLine("Press any button to continue.");
                retry = 5;
                while (!serialPort.CtsHolding && retry != 0)
                {
                    System.Threading.Thread.Sleep(1000);
                    retry--;
                    //Console.WriteLine("cts: {0:X2}", serialPort.CtsHolding);
                }
                if (!serialPort.CtsHolding)
                {
                    // データ送信可能にならなかった
                    Console.WriteLine("Failed to detect connection.");
                    serialPort.Close();
                    Environment.Exit(1);
                }
            }

            // データ送信可能

            // Read RAM 発行
            serialPort.Write(commandReadRAM, 0, commandReadRAM.Length);

            System.Threading.Thread.Sleep(500);

            if (serialPort.BytesToRead == expectedResultReadRAM.Length)
            {
                bytesInBuffer = serialPort.BytesToRead;

                result = new byte[bytesInBuffer];
                serialPort.Read(result, 0, bytesInBuffer);
                //Console.WriteLine("length: {0:X2}", bytesInBuffer);
                //ConsoleWriteBytesData(result);
                //Console.WriteLine("");

                productInfo = new byte[16];
                Array.Copy(result, 7, productInfo, 0, 16);
                Console.Write("The current device PRODUCTINFO is ");
                ConsoleWriteBytesData(productInfo);
                Console.WriteLine("");

                int i;
                for (i = 0; i < 7; i++)
                {
                    if (!result[i].Equals(expectedResultReadRAM[i]))
                    {
                        break;
                    }
                }
                if (i != 7)
                {
                    Console.WriteLine("Failed to read product info.");
                    serialPort.Close();
                    Environment.Exit(1);
                }
            }
            else
            {
                Console.WriteLine("Failed to read product info.");
                serialPort.Close();
                Environment.Exit(1);
            }

            serialPort.Close();

            // 終了
            Environment.Exit(0);
        }
    }
}
