﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System;
    using System.Globalization;
    using System.IO;
    using System.Reflection;
    using System.Threading;
    using System.Windows.Forms;
    using Forms;

    /// <summary>
    /// エントリーポイントを定義します。
    /// </summary>
    internal static class Program
    {
        /// <summary>
        /// エントリーポイントです。
        /// </summary>
        [STAThread]
        internal static void Main()
        {
            using (var mutex = new Mutex(false, "InputDirector"))
            {
                // 二重起動の禁止
                if (!mutex.WaitOne(0, false))
                {
                    return;
                }

                try
                {
                    if (File.Exists(GetResoucesDllPath()))
                    {
                        var cultureInfo = new CultureInfo("en", false);

                        Thread.CurrentThread.CurrentUICulture = cultureInfo;
                    }

                    Application.EnableVisualStyles();
                    Application.SetCompatibleTextRenderingDefault(false);

                    new MainForm();

                    Application.Run();
                }
                finally
                {
                    mutex.ReleaseMutex();
                }
            }
        }

        private static string GetResoucesDllPath()
        {
            return Path.Combine(
                Path.GetDirectoryName(Assembly.GetEntryAssembly().Location),
                "en", "InputDirector.resources.dll");
        }
    }
}
