﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.Windows.Forms;

    /// <summary>
    /// キーボードイベントのデータを提供します。
    /// </summary>
    internal class KeyboardEventArgs
    {
        /// <summary>
        /// KeyboardEventArgs クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="key">キーボードのキーです。</param>
        /// <param name="usageId">キーボードのキーの Usage ID です。</param>
        /// <param name="modifiers">キーボードの修飾キーです。</param>
        internal KeyboardEventArgs(Keys key, uint usageId)
        {
            this.Key = key;

            this.UsageId = usageId;
        }

        /// <summary>
        /// キーボードのキーを取得します。
        /// </summary>
        internal Keys Key { get; private set; }

        /// <summary>
        /// キーボードのキーの Usage ID を取得します。
        /// </summary>
        internal uint UsageId { get; private set; }

        /// <summary>
        /// キーボードイベントのデータの印字可能な表現を返します。
        /// </summary>
        /// <returns>キーボードイベントのデータの印字可能な表現です。</returns>
        public override string ToString()
        {
            return string.Format(
                "{0} {1}", this.UsageId.ToString("X2"), this.Key);
        }
    }
}
