﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.Threading;

    /// <summary>
    /// セッションに対する書き込みのインターフェイスです。
    /// </summary>
    internal interface ISessionWriter
    {
        /// <summary>
        /// セッションにバイトシーケンスを書き込みます。
        /// </summary>
        /// <param name="buffer">バイト配列です。</param>
        /// <param name="offset">バイト配列内のオフセットです。</param>
        /// <param name="count">書き込むバイト数です。</param>
        /// <param name="count">キャンセルトークンです。</param>
        void Write(
            byte[] buffer, int offset, int count, CancellationToken token);
    }
}
