﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.ComponentModel.Composition;

    /// <summary>
    /// セッション上で提供されるサービスのインターフェイスです。
    /// </summary>
    [InheritedExport]
    internal interface ISessionService
    {
        /// <summary>
        /// セッションの情報を設定します。
        /// </summary>
        SessionInfo Info { set; }

        /// <summary>
        /// サービスを開始します。
        /// </summary>
        /// <param name="writer">セッションへの書き込みを扱うライターです。</param>
        void Start(ISessionWriter writer);

        /// <summary>
        /// サービスを停止します。
        /// </summary>
        void Stop();

        /// <summary>
        /// サービスをキャンセルします。
        /// </summary>
        void Cancel();

        /// <summary>
        /// メッセージを受け付けます。
        /// </summary>
        /// <param name="message">メッセージです。</param>
        void AcceptMessage(byte[] message);
    }
}
