﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.Drawing;

    /// <summary>
    /// Capture サービスのセッションのインターフェイスです。
    /// </summary>
    internal interface ICaptureSession
    {
        /// <summary>
        /// セッションが完了したか否かを表す値を返します。
        /// </summary>
        bool IsCompleted { get; }

        /// <summary>
        /// セッションがマウス操作によって停止されたか否かを表す値を返します。
        /// </summary>
        bool IsStoppedByMouse { get; }

        /// <summary>
        /// マウスカーソルの座標値を返します。
        /// </summary>
        Point Position { get; }

        /// <summary>
        /// セッションを開始する際に呼び出されます。
        /// </summary>
        /// <param name="isTriggerdByMouse">セッションがマウス操作によって開始されたか否かを表す値です。</param>
        /// <param name="border">境界位置です。</param>
        /// <param name="screenSize">スクリーンサイズです。</param>
        /// <param name="position">マウスカーソルの座標値です。</param>
        void OnCaptureStart(
            bool isTriggerdByMouse,
            BorderType border, Rectangle screenSize, Point position);

        /// <summary>
        /// セッションを停止する際に呼び出されます。
        /// </summary>
        void OnCaptureStop();

        /// <summary>
        /// キーボードのキーが押された際に呼び出されます。
        /// </summary>
        /// <param name="args">キーボードイベントのデータです。</param>
        void OnKeyDown(KeyboardEventArgs args);

        /// <summary>
        /// キーボードのキーが離された際に呼び出されます。
        /// </summary>
        /// <param name="args">キーボードイベントのデータです。</param>
        void OnKeyUp(KeyboardEventArgs args);

        /// <summary>
        /// マウスカーソルが移動した際に呼び出されます。
        /// </summary>
        /// <param name="args">マウスイベントのデータです。</param>
        void OnMouseMove(MouseEventArgs args);

        /// <summary>
        /// マウスボタンが押された際に呼び出されます。
        /// </summary>
        /// <param name="args">マウスイベントのデータです。</param>
        void OnMouseDown(MouseEventArgs args);

        /// <summary>
        /// マウスボタンが離された際に呼び出されます。
        /// </summary>
        /// <param name="args">マウスイベントのデータです。</param>
        void OnMouseUp(MouseEventArgs args);

        /// <summary>
        /// マウスホイールが回転した際に呼び出されます。
        /// </summary>
        void OnMouseWheel(MouseEventArgs args);
    }
}
