﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    /// <summary>
    /// HidShell の結果コードです。
    /// </summary>
    internal enum HidShellResult : int
    {
        /// <summary>
        /// 成功しました。
        /// </summary>
        Success,

        /// <summary>
        /// ポートの書き込み先が NULL 値でした。
        /// </summary>
        NullPortPointer,

        /// <summary>
        /// ポートが不正でした。
        /// </summary>
        InvalidPort,

        /// <summary>
        /// ポートが見つかりませんでした。
        /// </summary>
        PortNotFound,

        /// <summary>
        /// ポートに空きがありませんでした。
        /// </summary>
        NoAvailablePort,

        /// <summary>
        /// ポートリストの書き込み先が NULL 値でした。
        /// </summary>
        NullPortListPointer,

        /// <summary>
        /// ポートのデータ転送方向が不正でした。
        /// </summary>
        InvalidPortDirection,

        /// <summary>
        /// ハンドルの書き込み先が NULL 値でした。
        /// </summary>
        NullHandlePointer,

        /// <summary>
        /// ハンドルが不正でした。
        /// </summary>
        InvalidHandle,

        /// <summary>
        /// ポート名が不正でした。
        /// </summary>
        InvalidPortName,

        /// <summary>
        /// 入力状態の書き込み先が NULL 値でした。
        /// </summary>
        NullStatePointer,

        /// <summary>
        /// 入力状態は設定されていませんでした。
        /// </summary>
        StateNotSet,

        /// <summary>
        /// ミューテックスの作成に失敗しました。
        /// </summary>
        FailedToCreateMutex,

        /// <summary>
        /// 共有メモリの作成に失敗しました。
        /// </summary>
        FailedToCreateSharedMemory,

        /// <summary>
        /// アドレスの書き込み先が NULL 値でした。
        /// </summary>
        NullAddressPointer,

        /// <summary>
        /// 存在フラグの書き込み先が NULL 値でした。
        /// </summary>
        NullExistenceFlagPointer,

        /// <summary>
        /// 撮影ボタンの入力状態が不正でした。
        /// </summary>
        InvalidCaptureButtonState,

        /// <summary>
        /// デバッグパッドの入力状態が不正でした。
        /// </summary>
        InvalidDebugPadState,

        /// <summary>
        /// ホームボタンの入力状態が不正でした。
        /// </summary>
        InvalidHomeButtonState,

        /// <summary>
        /// タッチパネルの入力状態が不正でした。
        /// </summary>
        InvalidTouchScreenState,

        /// <summary>
        /// 基本的な構成を持つ Xpad の入力状態が不正でした。
        /// </summary>
        InvalidBasicXpadState,

        /// <summary>
        /// 基本的な構成を持つ Xpad の ID が不正でした。
        /// </summary>
        InvalidBasicXpadId,
    }
}
