﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    /// <summary>
    /// ゲームパッドの電源状態を表します。
    /// </summary>
    internal enum GamePadPowerState : int
    {
        /// <summary>
        /// 切断
        /// </summary>
        Disconnected,

        /// <summary>
        /// バッテリー駆動
        /// </summary>
        OnBattery,

        /// <summary>
        /// 有線接続
        /// </summary>
        NoBattery,

        /// <summary>
        /// 充電中
        /// </summary>
        Charging,

        /// <summary>
        /// 充電完了
        /// </summary>
        Charged,
    }
}
