﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.Runtime.Serialization;

    /// <summary>
    /// ゲームパッド設定です。
    /// </summary>
    [DataContract(Name = "GamePad")]
    internal class GamePadConfig
    {
        /// <summary>
        /// GamePadConfig クラスの新しいインスタンスを初期化します。
        /// </summary>
        internal GamePadConfig()
        {
        }

        /// <summary>
        /// GamePadConfig クラスの新しいインスタンスを指定されたゲームパッド設定に基づいて初期化します。
        /// </summary>
        /// <param name="config">ゲームパッド設定です。</param>
        internal GamePadConfig(GamePadConfig config)
        {
            this.Name = config.Name;

            this.IsEnabled = config.IsEnabled;

            this.TargetName = config.TargetName;

            this.PlayerNumber = config.PlayerNumber;
        }

        /// <summary>
        /// ゲームパッドの名前を取得または設定します。
        /// </summary>
        [DataMember]
        internal string Name { get; set; } = string.Empty;

        /// <summary>
        /// ゲームパッドの入力転送が有効か否かを表す値を取得または設定します。
        /// </summary>
        [DataMember]
        internal bool IsEnabled { get; set; } = true;

        /// <summary>
        /// ゲームパッドの入力転送先となる開発機の名前を取得または設定します。
        /// </summary>
        [DataMember]
        internal string TargetName { get; set; } = string.Empty;

        /// <summary>
        /// ゲームパッドの入力転送と対応するプレイヤー番号を取得または設定します。
        /// </summary>
        [DataMember]
        internal int PlayerNumber { get; set; } = 0;
    }
}
