﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector.Forms
{
    using System;
    using System.Drawing;
    using System.Reflection;
    using System.Windows.Forms;

    /// <summary>
    /// バージョン情報フォームです。
    /// </summary>
    internal sealed partial class AboutForm : Form
    {
        /// <summary>
        /// AboutForm クラスの新しいインスタンスを初期化します。
        /// </summary>
        internal AboutForm()
        {
            InitializeComponent();

            this.pictureBoxIcon.Image = new Icon(this.Icon, 48, 48).ToBitmap();

            this.labelProductName.Text = string.Format(
                "{0} {1}",
                Application.ProductName, Application.ProductVersion);

            var attribute = (AssemblyCopyrightAttribute)
                Attribute.GetCustomAttribute(
                    Assembly.GetExecutingAssembly(),
                    typeof(AssemblyCopyrightAttribute));

            this.labelCopyright.Text = attribute.Copyright;
        }
    }
}
