﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.Runtime.Serialization;

    /// <summary>
    /// ボーダークロッシング設定です。
    /// </summary>
    [DataContract]
    internal sealed class BorderCrossingConfig
    {
        /// <summary>
        /// BorderCrossingConfig クラスの新しいインスタンスを初期化します。
        /// </summary>
        internal BorderCrossingConfig()
        {
        }

        /// <summary>
        /// BorderCrossingConfig クラスの新しいインスタンスを指定されたボーダークロッシング設定に基づいて初期化します。
        /// </summary>
        /// <param name="config">ボーダークロッシング設定です。</param>
        internal BorderCrossingConfig(BorderCrossingConfig config)
        {
            this.IsEnabled = config.IsEnabled;

            this.Border = config.Border;

            this.Trigger = config.Trigger;
        }

        /// <summary>
        /// ボーダークロッシングを有効化するか否かを表す値を取得または設定します。
        /// </summary>
        [DataMember]
        internal bool IsEnabled { get; set; } = true;

        /// <summary>
        /// ボーダークロッシングに使用する境界位置を取得または設定します。
        /// </summary>
        [DataMember]
        internal BorderType Border { get; set; } = BorderType.Right;

        /// <summary>
        /// ボーダークロッシングの種類を取得または設定します。
        /// </summary>
        [DataMember]
        internal BorderCrossingTriggerType Trigger { get; set; } =
            BorderCrossingTriggerType.Auto;
    }
}
