﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include "HidShellLibrary.h"

//!< HidShell の共有メモリの占有権を取得します。
HidShellResult AquireHidShellSharedMemoryExclusiveRight(
    HidShellHandle* pOutHandle) NN_NOEXCEPT;

//!< HidShell の共有メモリの占有権を開放します。
HidShellResult ReleaseHidShellSharedMemoryExclusiveRight(
    HidShellHandle handle) NN_NOEXCEPT;

//!< HidShell の共有メモリを作成します。
HidShellResult CreateHidShellSharedMemory(
    HidShellHandle handle, bool* pOutExists, uint32_t size) NN_NOEXCEPT;

//!< HidShell の共有メモリのアドレスを取得します。
HidShellResult GetHidShellSharedMemoryAddress(
    HidShellHandle handle, void** pOutAddress) NN_NOEXCEPT;
