﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "HidShellLibrary.h"
#include "HidShellLibrary_IoPort.h"

extern "C" int32_t AquireHidShellExclusiveRight(void** pOutHandle)
{
    return static_cast<int32_t>(
        AquireHidShellIoPortExclusiveRight(
            reinterpret_cast<HidShellHandle*>(pOutHandle)));
}

extern "C" int32_t ReleaseHidShellExclusiveRight(void* handle)
{
    return static_cast<int32_t>(
        ReleaseHidShellIoPortExclusiveRight(
            reinterpret_cast<HidShellHandle>(handle)));
}

extern "C" int32_t AttachHidShellPort(void* handle, const void* pName)
{
    if (pName == nullptr)
    {
        return static_cast<int32_t>(HidShellResult::InvalidPortName);
    }
    else
    {
        return static_cast<int32_t>(
            AttachHidShellIoPort(
                reinterpret_cast<HidShellHandle>(handle),
                *reinterpret_cast<const HidShellPortName*>(pName)));
    }
}

extern "C" int32_t DetachHidShellPort(void* handle, const void* pName)
{
    if (pName == nullptr)
    {
        return static_cast<int32_t>(HidShellResult::InvalidPortName);
    }
    else
    {
        return static_cast<int32_t>(
            DetachHidShellIoPort(
                reinterpret_cast<HidShellHandle>(handle),
                *reinterpret_cast<const HidShellPortName*>(pName)));
    }
}

extern "C" int32_t GetHidShellPort(
    void* handle, uint32_t* pOutPort, const void* pName)
{
    if (pName == nullptr)
    {
        return static_cast<int32_t>(HidShellResult::InvalidPortName);
    }
    else
    {
        return static_cast<int32_t>(
            GetHidShellIoPort(
                reinterpret_cast<HidShellHandle>(handle),
                pOutPort,
                *reinterpret_cast<const HidShellPortName*>(pName)));
    }
}

extern "C" int32_t GetHidShellPortList(void* handle, void* pOutList)
{
    return static_cast<int32_t>(
        GetHidShellIoPortList(
            reinterpret_cast<HidShellHandle>(handle),
            reinterpret_cast<HidShellPortList*>(pOutList)));
}

extern "C" int32_t GetHidShellCaptureButtonState(
    void* handle, void* pOutValue, uint32_t port, uint32_t direction)
{
    return static_cast<int32_t>(
        GetHidShellIoPortCaptureButtonState(
            reinterpret_cast<HidShellHandle>(handle),
            reinterpret_cast<HidShellCaptureButtonState*>(pOutValue),
            port, static_cast<HidShellPortDirection>(direction)));
}

extern "C" int32_t SetHidShellCaptureButtonState(
    void* handle, const void* pValue, uint32_t port, uint32_t direction)
{
    if (pValue == nullptr)
    {
        return static_cast<int32_t>(
            HidShellResult::InvalidCaptureButtonState);
    }
    else
    {
        return static_cast<int32_t>(
            SetHidShellIoPortCaptureButtonState(
                reinterpret_cast<HidShellHandle>(handle),
                *reinterpret_cast<const HidShellCaptureButtonState*>(pValue),
                port, static_cast<HidShellPortDirection>(direction)));
    }
}

extern "C" int32_t GetHidShellDebugPadState(
    void* handle, void* pOutValue, uint32_t port, uint32_t direction)
{
    return static_cast<int32_t>(
        GetHidShellIoPortDebugPadState(
            reinterpret_cast<HidShellHandle>(handle),
            reinterpret_cast<HidShellDebugPadState*>(pOutValue),
            port, static_cast<HidShellPortDirection>(direction)));
}

extern "C" int32_t SetHidShellDebugPadState(
    void* handle, const void* pValue, uint32_t port, uint32_t direction)
{
    if (pValue == nullptr)
    {
        return static_cast<int32_t>(
            HidShellResult::InvalidDebugPadState);
    }
    else
    {
        return static_cast<int32_t>(
            SetHidShellIoPortDebugPadState(
                reinterpret_cast<HidShellHandle>(handle),
                *reinterpret_cast<const HidShellDebugPadState*>(pValue),
                port, static_cast<HidShellPortDirection>(direction)));
    }
}

extern "C" int32_t GetHidShellHomeButtonState(
    void* handle, void* pOutValue, uint32_t port, uint32_t direction)
{
    return static_cast<int32_t>(
        GetHidShellIoPortHomeButtonState(
            reinterpret_cast<HidShellHandle>(handle),
            reinterpret_cast<HidShellHomeButtonState*>(pOutValue),
            port, static_cast<HidShellPortDirection>(direction)));
}

extern "C" int32_t SetHidShellHomeButtonState(
    void* handle, const void* pValue, uint32_t port, uint32_t direction)
{
    if (pValue == nullptr)
    {
        return static_cast<int32_t>(
            HidShellResult::InvalidHomeButtonState);
    }
    else
    {
        return static_cast<int32_t>(
            SetHidShellIoPortHomeButtonState(
                reinterpret_cast<HidShellHandle>(handle),
                *reinterpret_cast<const HidShellHomeButtonState*>(pValue),
                port, static_cast<HidShellPortDirection>(direction)));
    }
}

extern "C" int32_t GetHidShellTouchScreenState(
    void* handle, void* pOutValue, uint32_t port, uint32_t direction)
{
    return static_cast<int32_t>(
        GetHidShellIoPortTouchScreenState(
            reinterpret_cast<HidShellHandle>(handle),
            reinterpret_cast<HidShellTouchScreenState*>(pOutValue),
            port, static_cast<HidShellPortDirection>(direction)));
}

extern "C" int32_t SetHidShellTouchScreenState(
    void* handle, const void* pValue, uint32_t port, uint32_t direction)
{
    if (pValue == nullptr)
    {
        return static_cast<int32_t>(
            HidShellResult::InvalidTouchScreenState);
    }
    else
    {
        return static_cast<int32_t>(
            SetHidShellIoPortTouchScreenState(
                reinterpret_cast<HidShellHandle>(handle),
                *reinterpret_cast<const HidShellTouchScreenState*>(pValue),
                port, static_cast<HidShellPortDirection>(direction)));
    }
}

extern "C" int32_t GetHidShellBasicXpadState(
    void* handle,
    void* pOutValue, uint32_t id, uint32_t port, uint32_t direction)
{
    return static_cast<int32_t>(
        GetHidShellIoPortBasicXpadState(
            reinterpret_cast<HidShellHandle>(handle),
            reinterpret_cast<HidShellBasicXpadState*>(pOutValue), id,
            port, static_cast<HidShellPortDirection>(direction)));
}

extern "C" int32_t SetHidShellBasicXpadState(
    void* handle,
    const void* pValue, uint32_t id, uint32_t port, uint32_t direction)
{
    if (pValue == nullptr)
    {
        return static_cast<int32_t>(
            HidShellResult::InvalidBasicXpadState);
    }
    else
    {
        return static_cast<int32_t>(
            SetHidShellIoPortBasicXpadState(
                reinterpret_cast<HidShellHandle>(handle),
                *reinterpret_cast<const HidShellBasicXpadState*>(pValue), id,
                port, static_cast<HidShellPortDirection>(direction)));
    }
}

extern "C" int32_t GetHidShellAbstractedPadState(
    void* handle,
    void* pOutValue, uint32_t id, uint32_t port, uint32_t direction)
{
    if (pOutValue == nullptr)
    {
        return static_cast<int32_t>(
            HidShellResult::InvalidAbstractedPadState);
    }
    else
    {
        return static_cast<int32_t>(
            GetHidShellIoPortAbstractedPadState(
            reinterpret_cast<HidShellHandle>(handle),
            reinterpret_cast<HidShellAbstractedPadState*>(pOutValue), id,
            port, static_cast<HidShellPortDirection>(direction)));
    }
}

extern "C" int32_t SetHidShellAbstractedPadState(
    void* handle,
    const void* pValue, uint32_t id, uint32_t port, uint32_t direction)
{
    if (pValue == nullptr)
    {
        return static_cast<int32_t>(
            HidShellResult::InvalidAbstractedPadState);
    }
    else
    {
        return static_cast<int32_t>(
            SetHidShellIoPortAbstractedPadState(
                reinterpret_cast<HidShellHandle>(handle),
                *reinterpret_cast<const HidShellAbstractedPadState*>(pValue), id,
                port, static_cast<HidShellPortDirection>(direction)));
    }
}
