﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace HidShell
{
    using System;
    using System.Diagnostics;

    /// <summary>
    /// ロギング機能を提供します。
    /// </summary>
    internal sealed class Logger
    {
        private readonly object syncObject = new object();

        private readonly Stopwatch stopWatch = new Stopwatch();

        /// <summary>
        /// Logger クラスの新しいインスタンスを初期化します。
        /// </summary>
        internal Logger()
        {
            this.stopWatch.Start();
        }

        /// <summary>
        /// 指定された書式情報を利用してオブジェクト配列のテキスト表現を書き込みます。
        /// </summary>
        /// <param name="format">書式情報です。</param>
        /// <param name="args">オブジェクト配列です。</param>
        internal void WriteLine(string format, params object[] args)
        {
            lock (this.syncObject)
            {
                var elapsedTime = this.stopWatch.ElapsedMilliseconds;

                var seconds = elapsedTime / 1000.0;

                var message = string.Format(format, args);

                Console.WriteLine("[{0,11:F3}] {1}", seconds, message);
            }
        }
    }
}
