﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputCapture.Resources {
    using System;


    /// <summary>
    ///   ローカライズされた文字列などを検索するための、厳密に型指定されたリソース クラスです。
    /// </summary>
    // このクラスは StronglyTypedResourceBuilder クラスが ResGen
    // または Visual Studio のようなツールを使用して自動生成されました。
    // メンバーを追加または削除するには、.ResX ファイルを編集して、/str オプションと共に
    // ResGen を実行し直すか、または VS プロジェクトをビルドし直します。
    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("System.Resources.Tools.StronglyTypedResourceBuilder", "4.0.0.0")]
    [global::System.Diagnostics.DebuggerNonUserCodeAttribute()]
    [global::System.Runtime.CompilerServices.CompilerGeneratedAttribute()]
    internal class Strings {

        private static global::System.Resources.ResourceManager resourceMan;

        private static global::System.Globalization.CultureInfo resourceCulture;

        [global::System.Diagnostics.CodeAnalysis.SuppressMessageAttribute("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode")]
        internal Strings() {
        }

        /// <summary>
        ///   このクラスで使用されているキャッシュされた ResourceManager インスタンスを返します。
        /// </summary>
        [global::System.ComponentModel.EditorBrowsableAttribute(global::System.ComponentModel.EditorBrowsableState.Advanced)]
        internal static global::System.Resources.ResourceManager ResourceManager {
            get {
                if (object.ReferenceEquals(resourceMan, null)) {
                    global::System.Resources.ResourceManager temp = new global::System.Resources.ResourceManager("InputCapture.Resources.Strings", typeof(Strings).Assembly);
                    resourceMan = temp;
                }
                return resourceMan;
            }
        }

        /// <summary>
        ///   厳密に型指定されたこのリソース クラスを使用して、すべての検索リソースに対し、
        ///   現在のスレッドの CurrentUICulture プロパティをオーバーライドします。
        /// </summary>
        [global::System.ComponentModel.EditorBrowsableAttribute(global::System.ComponentModel.EditorBrowsableState.Advanced)]
        internal static global::System.Globalization.CultureInfo Culture {
            get {
                return resourceCulture;
            }
            set {
                resourceCulture = value;
            }
        }

        /// <summary>
        ///   常駐を開始しました。 に類似しているローカライズされた文字列を検索します。
        /// </summary>
        internal static string BalloonTip_TipText_Resident {
            get {
                return ResourceManager.GetString("BalloonTip_TipText_Resident", resourceCulture);
            }
        }

        /// <summary>
        ///   InputCapture に類似しているローカライズされた文字列を検索します。
        /// </summary>
        internal static string BalloonTip_TipTitle {
            get {
                return ResourceManager.GetString("BalloonTip_TipTitle", resourceCulture);
            }
        }

        /// <summary>
        ///   TV の下端へポインタを移動 に類似しているローカライズされた文字列を検索します。
        /// </summary>
        internal static string InfoDialog_TVBottom {
            get {
                return ResourceManager.GetString("InfoDialog_TVBottom", resourceCulture);
            }
        }

        /// <summary>
        ///   TV の左端へポインタを移動 に類似しているローカライズされた文字列を検索します。
        /// </summary>
        internal static string InfoDialog_TVLeft {
            get {
                return ResourceManager.GetString("InfoDialog_TVLeft", resourceCulture);
            }
        }

        /// <summary>
        ///   TV の右端へポインタを移動 に類似しているローカライズされた文字列を検索します。
        /// </summary>
        internal static string InfoDialog_TVRight {
            get {
                return ResourceManager.GetString("InfoDialog_TVRight", resourceCulture);
            }
        }

        /// <summary>
        ///   TV の上端へポインタを移動 に類似しているローカライズされた文字列を検索します。
        /// </summary>
        internal static string InfoDialog_TVTop {
            get {
                return ResourceManager.GetString("InfoDialog_TVTop", resourceCulture);
            }
        }

        /// <summary>
        ///   無効 に類似しているローカライズされた文字列を検索します。
        /// </summary>
        internal static string Invalid {
            get {
                return ResourceManager.GetString("Invalid", resourceCulture);
            }
        }
    }
}
