﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// GfxTexConverter

//=============================================================================
// include
//=============================================================================
#include "Convert.h"

using namespace std;

//=============================================================================
// texcvtr ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace texcvtr {

//-----------------------------------------------------------------------------
// 無名名前空間を開始します。
namespace
{

const int VersionMajor  = 4; //!< コンバーターのメジャーバージョンです。
const int VersionMinor  = 4; //!< コンバーターのマイナーバージョンです。
const int VersionMicro  = 0; //!< コンバーターのマイクロバージョンです。
const int VersionBugfix = 0; //!< コンバーターのバグフィックスバージョンです。

const bool SupportsFtx = false; //!< ftx ファイルに対応するなら true です。

//-----------------------------------------------------------------------------
// 無名名前空間を終了します。
} // unnamed namespace

//-----------------------------------------------------------------------------
//! @brief ftx ファイルのデータをデコードする関数を常にエラーを返す状態で定義します。
//-----------------------------------------------------------------------------
RStatus RImage::DecodeFtx(
    REncoder* pEncoder,
    const uint8_t* fileBuf,
    const size_t fileSize,
    const bool isBinary,
    const int readFlags
)
{
    R_UNUSED_VARIABLE(pEncoder);
    R_UNUSED_VARIABLE(fileBuf);
    R_UNUSED_VARIABLE(fileSize);
    R_UNUSED_VARIABLE(isBinary);
    R_UNUSED_VARIABLE(readFlags);
    return TexConverterBase::GetFtxUnsupportedStatus(m_FilePath);
}

//-----------------------------------------------------------------------------
//! @brief ftx ファイルを解析してマージ情報を取得する関数を常にエラーを返す状態で定義します。
//-----------------------------------------------------------------------------
RStatus RMergeInfo::ParseFtx(
    const uint8_t* fileBuf,
    const size_t fileSize,
    const bool isBinary
)
{
    R_UNUSED_VARIABLE(fileBuf);
    R_UNUSED_VARIABLE(fileSize);
    R_UNUSED_VARIABLE(isBinary);
    return TexConverterBase::GetFtxUnsupportedStatus(m_FilePath);
}

//-----------------------------------------------------------------------------
//! @brief ftx ファイルを出力する関数を常にエラーを返す状態で定義します。
//-----------------------------------------------------------------------------
RStatus RImage::OutputFtxFile(
    std::string* pOutputData,
    ROriginalImageArray* pOriginalImages,
    const std::string& filePath,
    const FtxOpt& opt,
    const std::string& toolVersionStr,
    const bool freesMemory
)
{
    R_UNUSED_VARIABLE(pOutputData);
    R_UNUSED_VARIABLE(pOriginalImages);
    R_UNUSED_VARIABLE(opt);
    R_UNUSED_VARIABLE(toolVersionStr);
    R_UNUSED_VARIABLE(freesMemory);
    return TexConverterBase::GetFtxUnsupportedStatus(filePath);
}

//-----------------------------------------------------------------------------
//! @brief gfx テクスチャーコンバーターのコンストラクターです。
//-----------------------------------------------------------------------------
GfxTexConverter::GfxTexConverter(HINSTANCE hDll)
:   TexConverterBase(hDll, VersionMajor, VersionMinor, VersionMicro, VersionBugfix, SupportsFtx)
{
    //cerr << "GfxTexConverter()" << endl;

    //-----------------------------------------------------------------------------
    // 各 DLL ファイルのパスを設定します。
    const std::string graphicsToolsPath = RGetFolderFromFilePath(RGetModuleFileName(hDll)) + "\\";
    m_Encoder.SetDllPath((graphicsToolsPath + "TextureConverterEncoder.dll").c_str());
    m_OpenExr.SetDllPath((graphicsToolsPath + "TextureConverterOpenExr.dll").c_str());
    m_NXUtility.SetDllPath((graphicsToolsPath + "TextureConverterNX.dll").c_str());
}

//-----------------------------------------------------------------------------
//! @brief gfx テクスチャーコンバーターのデストラクターです。
//-----------------------------------------------------------------------------
GfxTexConverter::~GfxTexConverter()
{
    //cerr << "~GfxTexConverter()" << endl;
}

//=============================================================================
// texcvtr ネームスペースを終了します。
//=============================================================================
} // texcvtr
} // tool
} // gfx
} // nn

