﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <gfxTool_WriteFileCallback.h>
#include <gfxTool_CommandLineArg.h>

namespace nn {
namespace gfxTool {

void WriteFileCallback::SetDirectory( const char* directory )
{
    m_Directory = directory;
    std::replace( m_Directory.begin(), m_Directory.end(), '/', '\\' );
    if( m_Directory.length() > 0 && m_Directory.back() != '\\' )
    {
        m_Directory.push_back( '\\' );
    }
}

bool WriteFileCallback::Callback( const void* pFileData, size_t fileDataSize,
    const char* pFilename, void* pParam )
{
    auto pThis = static_cast< WriteFileCallback* >( pParam );

    if( pThis->m_pCallback )
    {
        Custom< std::string >::Type path = pThis->m_Directory;
        path.append( pFilename );
        return pThis->m_pCallback( pFileData, fileDataSize, path.c_str(), pThis->m_pCallbackParam );
    }

    return false;
}

}
}
