﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cctype>

#include <nn/util/util_StringView.h>

#include <gfxTool_CompileOption-vk.h>
#include <gfxTool_CommandLineArg.h>

namespace nn {
namespace gfxTool {

CompileOptionVk::CompileOptionVk()
    : nngfxToolShaderCompilerCompileOptionVk()
{
    this->enableAutoMapUniformBinding = false;
    this->enableAutoMapInOutLocation = false;
    std::memset( this->reserved, 0, sizeof( this->reserved ) );
}

void CompileOptionVk::Initialize( const CommandLineArg* pInput )
{
    this->enableAutoMapUniformBinding = pInput->autoMapUniformBinding.IsExisting() ? 1 : 0;
    this->enableAutoMapInOutLocation = pInput->autoMapInOutLocation.IsExisting() ? 1 : 0;
}

}
}
