﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class VariationConstantValueNode;
class StageShaderVariationValueNode;
class ShaderVariationValueNode;

class VariationConstantValue
{
public:
    void Initialize( nngfxToolShaderCompilerVariationConstantValue* pArg,
        const VariationConstantValueNode* pVariationConstantValueNode,
        const nngfxToolShaderCompilerVariationConstantDefinition* pVariationConstantDefinition );

private:
    nngfxToolShaderCompilerVariationConstantValue* m_pArg;

    Custom< std::vector< uint32_t > >::Type m_ValueUint32;
    Custom< std::vector< float > >::Type m_ValueFloat32;
    Custom< std::vector< double > >::Type m_ValueFloat64;
};

class VariationValue
    : public nngfxToolShaderCompilerVariationValue
{
public:
    VariationValue()
        : nngfxToolShaderCompilerVariationValue()
    {
    }

    void Initialize( const StageShaderVariationValueNode* pStageShaderVariationNode,
        const nngfxToolShaderCompilerVariationDefinition* pVariationDefinition );

private:
    Custom< std::vector< nngfxToolShaderCompilerVariationConstantValue
        > >::Type m_VariationConstantValueArrayRaw;
    Custom< std::vector< nngfxToolString > >::Type m_PreprocessorDefinitionValueArrayRaw;

    Custom< std::vector< VariationConstantValue > >::Type m_VariationConstantValueArray;
    Custom< std::vector< Custom< std::string >::Type > >::Type m_PreprocessorDefinitionValueArray;
};

class VariationValueArg
{
public:
    void Initialize( nngfxToolShaderCompilerVariationValueArg* pArg,
        const ShaderVariationValueNode* pShaderVariationNode,
        const nngfxToolShaderCompilerVariationDefinitionArg* pVariationDefinitionArg );

private:
    nngfxToolShaderCompilerVariationValueArg* m_pArg;

    std::shared_ptr< VariationValue > m_pVariationValues[ ShaderStage::End ];
};

}
}
