﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/gfx/gfx_ResShaderData.h>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class ResShaderContainerBinarizer;
class ResShaderVariationBinarizer;

class ShaderCodeMerger
{
public:
    void MergeCode( ResShaderContainerBinarizer* pFileBinarier,
        const nngfxToolShaderConverterConvertArg* pArg );

    int GetAllCodeCount()
    {
        int ret = 0;
        for( auto&& count : m_Count )
        {
            ret += count;
        }
        return ret;
    }

    int GetAllMergedCodeCount()
    {
        int ret = 0;
        for( auto&& mergedCount : m_MergedCount )
        {
            ret += mergedCount;
        }
        return ret;
    }

private:
    enum class MergeType
    {
        Code,
        SourceArray,
        Data,
        Control,
        MetaData,
        AssemblyData,
        SpecializationData,
        PragmaData,
        AssemblyLocalsData,
        Uniform64InfoData,

        End
    };

    int m_Count[ static_cast<int>( MergeType::End ) ];
    int m_MergedCount[ static_cast<int>( MergeType::End ) ];

    void MergeShaderCode( const Custom< std::vector< ResShaderVariationBinarizer*
        > >::Type& pSortBinarizersOriginal, ShaderStage stage, int idxCodeType );
    void MergeSourceArrayCode( const Custom< std::vector< ResShaderVariationBinarizer*
        > >::Type& pSortBinarizersOriginal, ShaderStage stage, int codeArrayLength );
    void MergeNvnShaderCode( const Custom< std::vector< ResShaderVariationBinarizer*
        > >::Type& pSortBinarizersOriginal, ShaderStage stage );

    void ResetCount();
};

}
}
