﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include <nn/gfx/gfx_ShaderInfoData.h>

#include <gfxTool_Common.h>
#include <gfxTool_BinarizerBase.h>

namespace nn {
namespace gfxTool {

class ShaderBinarizerContext;
class ResShaderProgramBinarizer;

struct MergeBlock
{
    nn::util::MemorySplitter::MemoryBlock block;
    int merge;
};

class ShaderCodeBinarizerBase
    : public BinarizerBase
{
public:
    virtual ~ShaderCodeBinarizerBase()
    {
    }

    virtual const nn::util::MemorySplitter::MemoryBlock* GetShaderBinaryBlock() const
    {
        return nullptr;
    }
};

class ShaderCodeBinarizer
    : public ShaderCodeBinarizerBase
{
public:
    typedef nn::gfx::ShaderCode ResTarget;
    typedef nn::gfx::ShaderCode BinarizationTarget;

    void Initialize( const BinarizationTarget* pTarget, const ResShaderProgramBinarizer* pParent );

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void CalculateSize() override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;

    virtual const nn::util::MemorySplitter::MemoryBlock* GetShaderBinaryBlock() const override;

    const nn::gfx::ShaderCode* GetShaderCode() const
    {
        return m_pTarget;
    }

    const ResShaderProgramBinarizer* GetParent() const
    {
        return m_pParent;
    }

private:
    const BinarizationTarget* m_pTarget;
    const ResShaderProgramBinarizer* m_pParent;

    nn::util::MemorySplitter::MemoryBlock m_CodeBlock;
};

class SourceArrayBinarizer
    : public ShaderCodeBinarizerBase
{
public:
    typedef nn::gfx::SourceArrayCode ResTarget;
    typedef nn::gfx::SourceArrayCode BinarizationTarget;

    SourceArrayBinarizer()
        : m_pTarget()
        , m_pParent()
    {
    }

    void Initialize( const BinarizationTarget* pTarget,
        const ResShaderProgramBinarizer* pParent, ShaderStage stage );

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void CalculateSize() override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;

    void MergeSource( int idxSource, int targetVariation )
    {
        m_SourceBlocks[ idxSource ].merge = targetVariation;
    }

    const nn::gfx::SourceArrayCode* GetSourceArrayCode() const
    {
        return m_pTarget;
    }

    const ResShaderProgramBinarizer* GetParent() const
    {
        return m_pParent;
    }

private:
    const BinarizationTarget* m_pTarget;
    const ResShaderProgramBinarizer* m_pParent;

    ShaderStage m_Stage;

    nn::util::MemorySplitter::MemoryBlock m_CodeArrayBlock;
    nn::util::MemorySplitter::MemoryBlock m_CodeSizeArrayBlock;
    Custom< std::vector< MergeBlock > >::Type m_SourceBlocks;
};

}
}
