﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_ShaderCompilerDll.h>

struct nngfxToolShaderCompilerCompileArg;
struct nngfxToolShaderCompilerCompileOutput;

namespace nn {
namespace gfxTool {

class CompilerManager
{
public:
    CompilerManager();

    ~CompilerManager();

    void Reset();

    const nngfxToolShaderCompilerCompileOutput* GetCompileOutput() const
    {
        return m_pCompileOutput;
    }

    void Compile( const nngfxToolShaderCompilerCompileArg* pArg );

    void DeleteCompileOutput();

private:
    ShaderCompilerDll m_ShaderCompilerDll;
    nngfxToolHandle m_hShaderCompiler;

    nngfxToolShaderCompilerCompileOutput* m_pCompileOutput;
};

}
}
