﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

struct CommandLineArg;
class CompileOptionGlsl;
class CompileOptionGx;
class CompileOptionNvn;
class CompileOptionD3d;
class CompileOptionVk;

class CompileOptionCommon
    : public nngfxToolShaderCompilerCompileOptionCommon
{
public:
    CompileOptionCommon()
        : nngfxToolShaderCompilerCompileOptionCommon()
    {
    }

    void Initialize( const CommandLineArg* pInput );

private:
    Custom< std::vector< nngfxToolString > >::Type m_PreprocessorDefinitionArrayRaw;
    Custom< std::vector< Custom< std::string >::Type > >::Type m_PreprocessorDefinitionArray;
    Custom< std::string >::Type m_UniformRegisterBlockName;
};

class CompileOption
{
public:
    CompileOption();

    ~CompileOption();

    void Initialize( const CommandLineArg* pInput );

    const Custom< std::vector< nngfxToolShaderCompilerCompileOption > >::Type&
        GetCompileOptionArray() const
    {
        return m_CompileOptionArrayRaw;
    }

private:
    void AddCompileOption( nngfxToolShaderCompilerOptionType optionType, void* pOption );

    Custom< std::vector< nngfxToolShaderCompilerCompileOption > >::Type m_CompileOptionArrayRaw;

    Custom< std::unique_ptr< CompileOptionCommon > >::Type m_pCompileOptionCommon;
    Custom< std::unique_ptr< CompileOptionGlsl > >::Type m_pCompileOptionGlsl;
    Custom< std::unique_ptr< CompileOptionGx > >::Type m_pCompileOptionGx;
    Custom< std::unique_ptr< CompileOptionNvn > >::Type m_pCompileOptionNvn;
    Custom< std::unique_ptr< CompileOptionVk > >::Type m_pCompileOptionVk;
};

}
}
