﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <iterator>
#include <gfxTool_Common.h>
#include <gfxTool_CommandLineArg.h>

namespace nn {
namespace gfxTool {

class CompileOptionGlsl
    : public nngfxToolShaderCompilerCompileOptionGlsl
{
public:
    CompileOptionGlsl()
        : nngfxToolShaderCompilerCompileOptionGlsl()
    {
    }

    void Initialize( const CommandLineArg* pInput )
    {
        if( pInput->glslVersion.IsExisting() )
        {
            m_GlslVersion = std::move( pInput->glslVersion.GetValue() );
            this->glslVersion.pValue = m_GlslVersion.data();
            this->glslVersion.length = NumericCastAuto( m_GlslVersion.length() );
        }

        if( pInput->glslExtensions.IsExisting() )
        {
            m_GlslExtensionArray = std::move( pInput->glslExtensions.GetValue() );
            std::transform( m_GlslExtensionArray.cbegin(), m_GlslExtensionArray.cend(),
                std::back_inserter( m_GlslExtensionArrayRaw ), []( decltype( *m_GlslExtensionArray.cbegin() )& value )
            {
                nngfxToolString ret;
                TonngfxToolString( &ret, value );
                return ret;
            } );
            this->pGlslExtensionArray = m_GlslExtensionArrayRaw.data();
            this->glslExtensionCount = NumericCastAuto( m_GlslExtensionArrayRaw.size() );
        }
    }

private:
    Custom< std::string >::Type m_GlslVersion;
    Custom< std::vector< nngfxToolString > >::Type m_GlslExtensionArrayRaw;
    Custom< std::vector< Custom< std::string >::Type > >::Type m_GlslExtensionArray;
};

}
}
