﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <gfxTool_ShaderConverterDll.h>

namespace nn {
namespace gfxTool {

bool ShaderConverterDll::Initialize( const char* pDllPath )
{
    if( !DllBase::Initialize( pDllPath ) )
    {
        return false;
    }

    CreateHandle = GetRequiredFunction< decltype( CreateHandle ) >( "nngfxToolShaderConverterCreateHandle" );
    ResetHandle = GetRequiredFunction< decltype( ResetHandle ) > ( "nngfxToolShaderConverterResetHandle" );
    Convert = GetRequiredFunction< decltype( Convert ) >( "nngfxToolShaderConverterConvert" );
    Serialize = GetRequiredFunction< decltype( Serialize ) >( "nngfxToolShaderConverterSerialize" );
    DeleteHandle = GetRequiredFunction< decltype( DeleteHandle ) >( "nngfxToolShaderConverterDeleteHandle" );

    CreateConvertArg = GetRequiredFunction< decltype( CreateConvertArg ) >( "nngfxToolShaderConverterCreateConvertArg" );
    DeleteConvertArg = GetRequiredFunction< decltype( DeleteConvertArg ) >( "nngfxToolShaderConverterDeleteConvertArg" );

    SetLogStream = GetFunction< decltype( SetLogStream ) >( "nngfxToolShaderConverterSetLogStream" );
    GetApiVersion = GetFunction< decltype( GetApiVersion ) >( "nngfxToolShaderConverterGetApiVersion" );

    return true;
}

}
}
