﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <fstream>

#include <nn/gfxTool/gfxTool_ShaderCompilerApi-nvn.h>
#include <nvnTool/nvnTool_GlslcInterface.h>

#include <gfxTool_Dump.h>

namespace nn {
namespace gfxTool {

template<>
void DumpStatistics< static_cast< nngfxToolShaderCompilerLowLevelApiType >(
    nngfxToolShaderCompilerLowLevelApiType_Nvn ) >( std::ostream* pOs, const void* pStatistics )
{
    if( pOs == nullptr || pStatistics == nullptr )
    {
        return;
    }

    auto& statistics = *static_cast< const GLSLCperfStatsData* >( pStatistics );
    if(statistics.magic != GLSLC_PERF_STATS_SECTION_MAGIC_NUMBER )
    {
        return;
    }

    auto& os = *pOs;
    os << "Latency: " << statistics.latency;
    os << "\nSpillMem";
    os << "\n    NumLmemSpillBytes: " << statistics.spillMem.numLmemSpillBytes;
    os << "\n    NumLmemRefillBytes: " << statistics.spillMem.numLmemRefillBytes;
    os << "\n    NumSmemSpillBytes: " << statistics.spillMem.numSmemSpillBytes;
    os << "\n    NumSmemRefillBytes: " << statistics.spillMem.numSmemRefillBytes;
    os << "\n    Size: " << statistics.spillMem.size;
    os << "\nNonSpillLMem";
    os << "\n    LoadBytes: " << statistics.nonSpillLMem.loadBytes;
    os << "\n    StoreBytes: " << statistics.nonSpillLMem.storeBytes;
    os << "\n    Size: " << statistics.nonSpillLMem.size;
    os << "\nOccupancy: " << statistics.occupancy;
    os << "\nNumDivergentBranches: " << statistics.numDivergentBranches;
    os << "\nAttributeMemUsage: " << statistics.attributeMemUsage;
    os << "\nProgramSize: " << statistics.programSize;
    os << "\nRequiresGlobalLoadUniformEmulation: " <<
        ( statistics.requiresGlobalLoadUniformEmulation ? "true" : "false" );
    os << "\nFp16VectPercent: " << statistics.fp16VectPercent;
    os << "\nThroughputLimiter";
    os << "\n    Issue: " << statistics.throughputLimiter.issue;
    os << "\n    Fp: " << statistics.throughputLimiter.fp;
    os << "\n    Half: " << statistics.throughputLimiter.half;
    os << "\n    Trancedental: " << statistics.throughputLimiter.trancedental;
    os << "\n    Ipa: " << statistics.throughputLimiter.ipa;
    os << "\n    Shared: " << statistics.throughputLimiter.shared;
    os << "\n    ControlFlow: " << statistics.throughputLimiter.controlFlow;
    os << "\n    TexLoadStore: " << statistics.throughputLimiter.texLoadStore;
    os << "\n    Reg: " << statistics.throughputLimiter.reg;
    os << "\n    Warp: " << statistics.throughputLimiter.warp;
    os << "\n    SharedMemResource: " << statistics.throughputLimiter.sharedMemResource;
    os << "\nLoopData";
    os << "\n    PartiallyUnrolled: " << statistics.loopData.partiallyUnrolled;
    os << "\n    NonUnrolled: " << statistics.loopData.nonUnrolled;
    os << "\n\n\n";
}

template<>
void DumpOptionOutputProgram< static_cast< nngfxToolShaderCompilerOptionOutputType >(
    nngfxToolShaderCompilerOptionOutputType_ProgramNvn ) >( std::ostream* pOs,
    const void* pOptionOutput, nn::gfx::ShaderStage stage )
{
    static nngfxToolShaderCompilerOptionOutputStageNvn*
        nngfxToolShaderCompilerOptionOutputProgramNvn::* const s_pStageOutput[] =
    {
        &nngfxToolShaderCompilerOptionOutputProgramNvn::pVertexStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramNvn::pHullStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramNvn::pDomainStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramNvn::pGeometryStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramNvn::pPixelStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramNvn::pComputeStageOutput
    };

    if( pOs == nullptr || pOptionOutput == nullptr )
    {
        return;
    }

    auto pOptionOutputProgramNvn = static_cast<
        const nngfxToolShaderCompilerOptionOutputProgramNvn* >( pOptionOutput );
    if( auto pOutputStageNvn = pOptionOutputProgramNvn->*s_pStageOutput[ stage ] )
    {
        auto& os = *pOs;
        const char* const separator = "------------------------";
        os << separator << "Shader Information" << separator << "\n";
        os << "RequiredScratchMemorySizePerWarp: " <<
            pOutputStageNvn->requiredScratchMemorySizePerWarp << "\n";
        os << "RecommendedScratchMemorySizePerWarp: " <<
            pOutputStageNvn->recommendedScratchMemorySizePerWarp << "\n";
        os << "\n\n";
    }
}

}
}
