﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <gfxTool_VariationManager.h>
#include <gfxTool_VariationGrouper.h>
#include <gfxTool_GroupSource.h>

namespace nn {
namespace gfxTool {

VariationManager::VariationManager() /* = default; */
{
}

VariationManager::~VariationManager() /* = default; */
{
}

void VariationManager::Initialize( const nngfxToolShaderCompilerCompileArg* pArg )
{
    m_VariationCount = pArg->variationCount;

    for( int idxStage = 0; idxStage < static_cast< int >( ShaderStage::End ); ++idxStage )
    {
        auto stage = static_cast< ShaderStage >( idxStage );
        if( GetStageSource( pArg, stage ).pValue == nullptr )
        {
            continue;
        }

        {
            m_pVariationConstantGroup[ idxStage ].reset( new VariationGrouper() );
            m_pVariationConstantGroup[ idxStage ]->Initialize( pArg,
                VariationGrouper::LessConstantValue, stage );

            if( pArg->shaderSourceFormat == nngfxToolShaderCompilerShaderSourceFormat_Glsl )
            {
                if( pArg->targetLowLevelApiType == nngfxToolShaderCompilerLowLevelApiType_Gl
                    || pArg->targetLowLevelApiType == nngfxToolShaderCompilerLowLevelApiType_Vk )
                {
                    m_pVariationConstantSource[ idxStage ].reset( new VariationConstantSource() );
                    m_pVariationConstantSource[ idxStage ]->Initialize<
                        nngfxToolShaderCompilerShaderSourceFormat_Glsl >( pArg,
                            &m_pVariationConstantGroup[ idxStage ]->GetGroupToHeadVariationTable(), stage );
                }
            }
            else if( pArg->shaderSourceFormat == nngfxToolShaderCompilerShaderSourceFormat_Hlsl )
            {
                m_pVariationConstantSource[ idxStage ].reset( new VariationConstantSource() );
                m_pVariationConstantSource[ idxStage ]->Initialize<
                    nngfxToolShaderCompilerShaderSourceFormat_Hlsl >( pArg,
                        &m_pVariationConstantGroup[ idxStage ]->GetGroupToHeadVariationTable(), stage );
            }
        }

        m_pPreprocessorDefinitionGroup[ idxStage ].reset( new VariationGrouper() );
        m_pPreprocessorDefinitionGroup[ idxStage ]->Initialize( pArg,
            VariationGrouper::LessPreprocessorDefinition, stage );

        m_pPreprocessorDefinitionSource[ idxStage ].reset( new PreprocessorDefinitionSource() );
        m_pPreprocessorDefinitionSource[ idxStage ]->Initialize( pArg,  &m_pPreprocessorDefinitionGroup[
            idxStage ]->GetGroupToHeadVariationTable(), stage );

        Custom< std::vector< const VariationGrouper* > >::Type groupers;
        groupers.reserve( 2 );
        groupers.push_back( m_pVariationConstantGroup[ idxStage ].get() );
        groupers.push_back( m_pPreprocessorDefinitionGroup[ idxStage ].get() );
        m_pVariationGroup[ idxStage ].reset( new VariationGrouper() );
        m_pVariationGroup[ idxStage ]->Intersect( groupers );
    }

    {
        m_pCombinedPreprocessorDefinitionGroup.reset( new VariationGrouper() );
        Custom< std::vector< const VariationGrouper* > >::Type groupers;
        for( int idxStage = 0; idxStage < static_cast< int >( ShaderStage::End ); ++idxStage )
        {
            auto stage = static_cast< ShaderStage >( idxStage );
            if( GetStageSource( pArg, stage ).pValue )
            {
                groupers.push_back( m_pPreprocessorDefinitionGroup[ idxStage ].get() );
            }
        }
        m_pCombinedPreprocessorDefinitionGroup->Intersect( groupers );
    }
}

}
}
