﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <gfxTool_ShaderUtilsDll.h>

namespace nn {
namespace gfxTool {

bool ShaderUtilsDll::Initialize( const char* pDllPath )
{
    if( !DllBase::Initialize( pDllPath ) )
    {
        return false;
    }

    this->Gsh2GetAbiVersion = GetRequiredFunction< decltype( this->Gsh2GetAbiVersion ) >( "GSH2GetABIVersion" );

    this->Gsh2Initialize = GetRequiredFunction< decltype( this->Gsh2Initialize ) >( "GSH2Initialize" );
    this->Gsh2Destroy = GetRequiredFunction< decltype( this->Gsh2Destroy ) >( "GSH2Destroy" );

    this->Gsh2CompileProgram = GetRequiredFunction< decltype( this->Gsh2CompileProgram ) >( "GSH2CompileProgram" );
    this->Gsh2CompileProgram2 = GetRequiredFunction< decltype( this->Gsh2CompileProgram2 ) >( "GSH2CompileProgram2" );
    this->Gsh2CompileProgram3 = GetRequiredFunction< decltype( this->Gsh2CompileProgram3 ) >( "GSH2CompileProgram3" );
    this->Gsh2DestroyGx2Program = GetRequiredFunction< decltype( this->Gsh2DestroyGx2Program ) >( "GSH2DestroyGX2Program" );
    this->Gsh2DestroyGx2Program3 = GetRequiredFunction< decltype( this->Gsh2DestroyGx2Program3 ) >( "GSH2DestroyGX2Program3" );

    this->Gsh2CalcFetchShaderSizeEx = GetRequiredFunction< decltype( this->Gsh2CalcFetchShaderSizeEx ) >( "GSH2CalcFetchShaderSizeEx" );
    this->Gsh2InitFetchShaderEx = GetRequiredFunction< decltype( this->Gsh2InitFetchShaderEx ) >( "GSH2InitFetchShaderEx" );

    this->Gsh2GetVertexShaderGprs = GetRequiredFunction< decltype( this->Gsh2GetVertexShaderGprs ) >( "GSH2GetVertexShaderGPRs" );
    this->Gsh2GetGeometryShaderGprs = GetRequiredFunction< decltype( this->Gsh2GetGeometryShaderGprs ) >( "GSH2GetGeometryShaderGPRs" );
    this->Gsh2GetPixelShaderGprs = GetRequiredFunction< decltype( this->Gsh2GetPixelShaderGprs ) >( "GSH2GetPixelShaderGPRs" );
    this->Gsh2GetVertexShaderStackEntries = GetRequiredFunction< decltype( this->Gsh2GetVertexShaderStackEntries ) >( "GSH2GetVertexShaderStackEntries" );
    this->Gsh2GetGeometryShaderStackEntries = GetRequiredFunction< decltype( this->Gsh2GetGeometryShaderStackEntries ) >( "GSH2GetGeometryShaderStackEntries" );
    this->Gsh2GetPixelShaderStackEntries = GetRequiredFunction< decltype( this->Gsh2GetPixelShaderStackEntries ) >( "GSH2GetPixelShaderStackEntries" );

    this->Gsh2CreateSetFetchShaderDl = GetRequiredFunction< decltype( this->Gsh2CreateSetFetchShaderDl ) >( "GSH2CreateSetFetchShaderDL" );
    this->Gsh2CreateSetVertexShaderDl = GetRequiredFunction< decltype( this->Gsh2CreateSetVertexShaderDl ) >( "GSH2CreateSetVertexShaderDL" );
    this->Gsh2CreateSetGeometryShaderDl = GetRequiredFunction< decltype( this->Gsh2CreateSetGeometryShaderDl ) >( "GSH2CreateSetGeometryShaderDL" );
    this->Gsh2CreateSetPixelShaderDl = GetRequiredFunction< decltype( this->Gsh2CreateSetPixelShaderDl ) >( "GSH2CreateSetPixelShaderDL" );
    this->Gsh2CreateSetComputeShaderDl = GetRequiredFunction< decltype( this->Gsh2CreateSetComputeShaderDl ) >( "GSH2CreateSetComputeShaderDL" );
    this->Gsh2FreeDl = GetRequiredFunction< decltype( this->Gsh2FreeDl ) >( "GSH2FreeDL" );

    return true;
}

}
}
