﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_OptionOutput.h>

namespace nn {
namespace gfxTool {

void OptionOutputStageCommon::SetInfoLog( std::shared_ptr< Custom< std::string >::Type > pInfoLog )
{
    m_pInfoLog = pInfoLog;
    if( m_pInfoLog.get() )
    {
        this->infoLog.pValue = m_pInfoLog->c_str();
        this->infoLog.length = NumericCastAuto( m_pInfoLog->length() );
    }
}

void OptionOutputStageCommon::SetDump( std::shared_ptr< Custom< std::string >::Type > pDump )
{
    m_pDump = pDump;
    if( m_pDump.get() )
    {
        this->dump.pValue = m_pDump->c_str();
        this->dump.length = NumericCastAuto( m_pDump->length() );
    }
}

void OptionOutputStageCommon::SetShaderStatistics( std::shared_ptr< void > pValue )
{
    m_pShaderStatistics = pValue;
    if( m_pShaderStatistics.get() )
    {
        this->pShaderStatistics = m_pShaderStatistics.get();
    }
}

void OptionOutputProgramCommon::Initialize( const nngfxToolShaderCompilerCompileArg* pArg )
{
    static nngfxToolShaderCompilerOptionOutputStageCommon*
        nngfxToolShaderCompilerOptionOutputProgramCommon::* const s_pStages[] =
    {
        &nngfxToolShaderCompilerOptionOutputProgramCommon::pVertexStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramCommon::pHullStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramCommon::pDomainStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramCommon::pGeometryStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramCommon::pPixelStageOutput,
        &nngfxToolShaderCompilerOptionOutputProgramCommon::pComputeStageOutput
    };
    for( int idxStage = 0; idxStage < static_cast< int >( ShaderStage::End ); ++idxStage )
    {
        if( GetStageSource( pArg, static_cast< ShaderStage >( idxStage ) ).pValue )
        {
            this->*s_pStages[ idxStage ] = m_StageOutput[ idxStage ].GetOutput();
        }
    }
}

}
}
