﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class ProgramOutput;

class VariationOutput
{
public:
    VariationOutput();

    ~VariationOutput();

    nngfxToolShaderCompilerVariationOutput* GetOutput()
    {
        return m_pOutput;
    }

    ProgramOutput* GetSourceOutput()
    {
        return m_pSourceOutput.get();
    }

    ProgramOutput* GetIntermediateLanguageOutput()
    {
        return m_pIrOutput.get();
    }

    ProgramOutput* GetBinaryOutput()
    {
        return m_pBinaryOutput.get();
    }

    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg,
        nngfxToolShaderCompilerVariationOutput* pOutput );

private:
    nngfxToolShaderCompilerVariationOutput* m_pOutput;

    Custom< std::unique_ptr< ProgramOutput > >::Type m_pSourceOutput;
    Custom< std::unique_ptr< ProgramOutput > >::Type m_pIrOutput;
    Custom< std::unique_ptr< ProgramOutput > >::Type m_pBinaryOutput;
};

}
}
