﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <unordered_map>

#include <nn/util/util_StringView.h>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class PreprocessorDirectiveCallbackBase
{
public:
    virtual bool operator()( Custom< std::string >::Type* pOut,
        const nn::util::string_view* pDirective ) = 0;
};

Custom< std::string >::Type SimplePreprocess( const nn::util::string_view* pSource,
    PreprocessorDirectiveCallbackBase* pCallback );

template< nngfxToolShaderCompilerShaderSourceFormat >
Custom< std::string >::Type CreateVariationBufferSource(
    nn::util::string_view* pOutBeforeVariationBuffer, nn::util::string_view* pOutAfterVariationBuffer,
    const nn::util::string_view* pSource, const nngfxToolShaderCompilerVariationDefinition* pDefinition );

class ExpandIncludeCallback
    : public PreprocessorDirectiveCallbackBase
{
public:
    ExpandIncludeCallback( nngfxToolReadFileCallback pCallback, void* pCallbackParam )
        : m_pCallback( pCallback )
        , m_pCallbackParam( pCallbackParam )
    {
    }

    virtual bool operator()( Custom< std::string >::Type* pOut,
        const nn::util::string_view* pDirective ) override;

    void SetSimplePreprocessCallback( PreprocessorDirectiveCallbackBase* pCallback )
    {
        m_pSimplePreprocessCallback = pCallback;
    }

private:
    nngfxToolReadFileCallback m_pCallback;
    void* m_pCallbackParam;
    PreprocessorDirectiveCallbackBase* m_pSimplePreprocessCallback;
};

class CommentOutMacroCallback
    : public PreprocessorDirectiveCallbackBase
{
public:
    explicit CommentOutMacroCallback(
        Custom< std::vector< Custom< std::string >::Type > >::Type* pMacros )
        : m_pMacros( pMacros )
    {
    }

    bool operator()( Custom< std::string >::Type* pOut,
        const nn::util::string_view* pDirective ) override;

private:
    const Custom< std::vector< Custom< std::string >::Type > >::Type* m_pMacros;
};

class PreprocessorDirectiveMultiCallback
    : public PreprocessorDirectiveCallbackBase
{
public:
    PreprocessorDirectiveMultiCallback(
        const Custom< std::vector< PreprocessorDirectiveCallbackBase* > >::Type* pCallbacks )
        : m_pCallbacks( pCallbacks )
    {
    }

    bool operator()( Custom< std::string >::Type* pOut,
        const nn::util::string_view* pDirective ) override;

private:
    const Custom< std::vector< nn::gfxTool::PreprocessorDirectiveCallbackBase* > >::Type* m_pCallbacks;
};

}
}
